﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Chapitre_12
{
    class Cube
    {
        VertexPositionColor[] vertices;
        short[] indices;
        BasicEffect effect;
        GraphicsDevice graphicsDevice;
        Vector3 position;
        float widthOver2;

        public Cube(GraphicsDevice graphicsDevice, Vector3 position, float width, Matrix projection, Matrix view)
        {
            this.graphicsDevice = graphicsDevice;
            this.position = position;
            this.widthOver2 = width / 2;

            effect = new BasicEffect(graphicsDevice, null);
            effect.Projection = projection;
            effect.View = view;
            effect.LightingEnabled = false;
            effect.VertexColorEnabled = true;

            InitializeVertices();
            InitializeIndices();
        }

        public void Draw()
        {
            graphicsDevice.VertexDeclaration = new VertexDeclaration(graphicsDevice, VertexPositionColor.VertexElements);

            effect.Begin();
            foreach (EffectPass CurrentPass in effect.CurrentTechnique.Passes)
            {
                CurrentPass.Begin();
                graphicsDevice.DrawUserIndexedPrimitives(PrimitiveType.TriangleList, vertices, 0, vertices.Length, indices, 0, indices.Length / 3);
                CurrentPass.End();
            }
            effect.End();
        }

        private void InitializeVertices()
        {
            vertices = new VertexPositionColor[8];

            // Front Top left corner
            vertices[0].Position = new Vector3(position.X - widthOver2, position.Y + widthOver2, position.Z + widthOver2);
            vertices[0].Color = Color.White;

            // Front Bottom right corner
            vertices[1].Position = new Vector3(position.X + widthOver2, position.Y - widthOver2, position.Z + widthOver2);
            vertices[1].Color = Color.Red;

            // Front Bottom left corner
            vertices[2].Position = new Vector3(position.X - widthOver2, position.Y - widthOver2, position.Z + widthOver2);
            vertices[2].Color = Color.Green;

            // Front Top right corner
            vertices[3].Position = new Vector3(position.X + widthOver2, position.Y + widthOver2, position.Z + widthOver2);
            vertices[3].Color = Color.Yellow;

            // Back Top left corner
            vertices[4].Position = new Vector3(position.X + widthOver2, position.Y + widthOver2, position.Z - widthOver2);
            vertices[4].Color = Color.Blue;

            // Back Bottom right corner
            vertices[5].Position = new Vector3(position.X - widthOver2, position.Y - widthOver2, position.Z - widthOver2);
            vertices[5].Color = Color.Orange;

            // Back Bottom left corner
            vertices[6].Position = new Vector3(position.X + widthOver2, position.Y - widthOver2, position.Z - widthOver2);
            vertices[6].Color = Color.Black;

            // Back Top right corner
            vertices[7].Position = new Vector3(position.X - widthOver2, position.Y + widthOver2, position.Z - widthOver2);
            vertices[7].Color = Color.Violet;
        }

        private void InitializeIndices()
        {
            indices = new short[36];

            // Front
            indices[0] = 0;
            indices[1] = 1;
            indices[2] = 2;
            indices[3] = 0;
            indices[4] = 3;
            indices[5] = 1;

            // Right
            indices[6] = 3;
            indices[7] = 6;
            indices[8] = 1;
            indices[9] = 3;
            indices[10] = 4;
            indices[11] = 6;

            // Top
            indices[12] = 7;
            indices[13] = 3;
            indices[14] = 0;
            indices[15] = 7;
            indices[16] = 4;
            indices[17] = 3;

            // Back
            indices[18] = 4;
            indices[19] = 5;
            indices[20] = 6;
            indices[21] = 4;
            indices[22] = 7;
            indices[23] = 5;

            // Left
            indices[24] = 7;
            indices[25] = 2;
            indices[26] = 5;
            indices[27] = 7;
            indices[28] = 0;
            indices[29] = 2;

            // Bottom
            indices[30] = 6;
            indices[31] = 2;
            indices[32] = 1;
            indices[33] = 6;
            indices[34] = 5;
            indices[35] = 2;
        }
    }
}
